/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */  

#ifndef __MUSB_HDRDF_H__
#define __MUSB_HDRDF_H__

/* Netra USB susbsystem register offsets */
#define USBSS_REVISION          0x0000
#define USBSS_SYSCONFIG         0x0010
/* USBSS EOI interrupt register */
#define USBSS_IRQ_EOI           0x0020
/* USBSS interrupt generation/status register */
#define USBSS_IRQ_STATUS_RAW        0x0024
/* USBSS interrupt status register */
#define USBSS_IRQ_STATUS        0x0028
/* USBSS interrupt enable register */
#define USBSS_IRQ_ENABLE_SET        0x002c
/* USBSS interrupt clear register */
#define USBSS_IRQ_ENABLE_CLEAR      0x0030
/* USB0: TxDMA 8bit tx completion interrupt pacing
    threshold value for ep1..15 */
#define USBSS_IRQ_DMA_THRESHOLD_TX0 0x0100
/* USB0: RxDMA 8bit rx completion interrupt pacing
    threshold value for ep1..15 */
#define USBSS_IRQ_DMA_THRESHOLD_RX0 0x0110
/* USB1: TxDMA 8bit tx completion interrupt pacing
    threshold value for ep1..15 */
#define USBSS_IRQ_DMA_THRESHOLD_TX1 0x0120
/* USB1: RxDMA 8bit rx completion interrupt pacing
    threshold value for ep1..15 */
#define USBSS_IRQ_DMA_THRESHOLD_RX1 0x0130
/* USB0: TxDMA threshold enable tx completion for ep1..ep15
    RxDMA threshold enable rx completion for ep1..ep15 */
#define USBSS_IRQ_DMA_ENABLE_0      0x0140
/* USB1: TxDMA threshold enable for ep1..ep15
    RxDMA threshold enable for ep1..ep15 */
#define USBSS_IRQ_DMA_ENABLE_1      0x0144
/* USB0: TxDMA Frame threshold for tx completion for ep1..ep15
    RxDMA Frame threshold for rx completion for ep1..ep15 */
#define USBSS_IRQ_FRAME_THRESHOLD_TX0   0x0200
#define USBSS_IRQ_FRAME_THRESHOLD_RX0   0x0210
/* USB1: TxDMA Frame threshold for tx completion for ep1..ep15
    RxDMA Frame threshold for rx completion for ep1..ep15 */
#define USBSS_IRQ_FRAME_THRESHOLD_TX1   0x0220
#define USBSS_IRQ_FRAME_THRESHOLD_RX1   0x0230
/* USB0: Frame threshold enable tx completion for ep1..ep15
    Frame threshold enable rx completion for ep1..ep15 */
#define USBSS_IRQ_FRAME_ENABLE_0    0x0240
#define USBSS_IRQ_FRAME_ENABLE_1    0x0244


/* USB 2.0 OTG module registers */
#define USB_REVISION_REG        0x0000
#define USB_CTRL_REG            0x0014
#define USB_STAT_REG            0x0018
#define USB_IRQ_MERGED_STATUS   0x0020
#define USB_IRQ_EOI     0x0024
#define USB_IRQ_STATUS_RAW_0    0x0028
#define USB_IRQ_STATUS_RAW_1    0x002c
#define USB_IRQ_STATUS_0    0x0030
#define USB_IRQ_STATUS_1    0x0034
#define USB_IRQ_ENABLE_SET_0    0x0038
#define USB_IRQ_ENABLE_SET_1    0x003c
#define USB_IRQ_ENABLE_CLR_0    0x0040
#define USB_IRQ_ENABLE_CLR_1    0x0044

#define USB_EP_INTR_SET_REG     (USB_IRQ_ENABLE_SET_0)
#define USB_CORE_INTR_SET_REG       (USB_IRQ_ENABLE_SET_1)
#define USB_EP_INTR_CLEAR_REG       (USB_IRQ_ENABLE_CLR_0)
#define USB_CORE_INTR_CLEAR_REG     (USB_IRQ_ENABLE_CLR_1)
#define USB_EP_INTR_STATUS_REG      (USB_IRQ_STATUS_0)
#define USB_CORE_INTR_STATUS_REG    (USB_IRQ_STATUS_1)

#define USB_TX_MODE_REG     0x0070
#define USB_RX_MODE_REG     0x0074

#define USB_GRNDIS_EPSIZE_OFFS  0X0080
#define USB_GENERIC_RNDIS_EP_SIZE_REG(n) (0x0080 + (((n) - 1) << 2))
#define USB_AUTOREQ_REG         0x00d0
#define USB_SRP_FIX_TIME_REG    0x00d4
#define USB_TEARDOWN_REG        0x00d8
#define USB_PHY_UTMI_REG    0x00e0
#define USB_PHY_UTMI_LB_REG 0x00e4
#define USB_MODE_REG        0x00e8

#define QUEUE_THRESHOLD_INTR_ENABLE_REG 0xc0
#define QUEUE_63_THRESHOLD_REG  0xc4
#define QUEUE_63_THRESHOLD_INTR_CLEAR_REG 0xc8
#define QUEUE_65_THRESHOLD_REG  0xd4
#define QUEUE_65_THRESHOLD_INTR_CLEAR_REG 0xd8

/* Control register bits */
#define USB_SOFT_RESET_MASK     1
/* Mode register bits */
#define USB_MODE_SHIFT(n)       ((((n) - 1) << 1))
#define USB_MODE_MASK(n)        (3 << USB_MODE_SHIFT(n))
#define USB_RX_MODE_SHIFT(n)    USB_MODE_SHIFT(n)
#define USB_TX_MODE_SHIFT(n)    USB_MODE_SHIFT(n)
#define USB_RX_MODE_MASK(n)     USB_MODE_MASK(n)
#define USB_TX_MODE_MASK(n)     USB_MODE_MASK(n)
#define USB_TRANSPARENT_MODE    0
#define USB_RNDIS_MODE          1
#define USB_CDC_MODE            2
#define USB_GENERIC_RNDIS_MODE  3

/* AutoReq register bits */
#define USB_RX_AUTOREQ_SHIFT(n) (((n) - 1) << 1)
#define USB_RX_AUTOREQ_MASK(n)  (3 << USB_RX_AUTOREQ_SHIFT(n))
#define USB_NO_AUTOREQ          0
#define USB_AUTOREQ_ALL_BUT_EOP 1
#define USB_AUTOREQ_ALWAYS      3

/* Teardown register bits */
#define USB_TX_TDOWN_SHIFT(n)   (16 + (n))
#define USB_TX_TDOWN_MASK(n)    (1 << USB_TX_TDOWN_SHIFT(n))
#define USB_RX_TDOWN_SHIFT(n)   (n)
#define USB_RX_TDOWN_MASK(n)    (1 << USB_RX_TDOWN_SHIFT(n))

/* USB interrupt register bits */
#define USB_INTR_USB_SHIFT      0
#define USB_INTR_USB_MASK       (0x1ff << USB_INTR_USB_SHIFT) /* 8 Mentor */
                /* interrupts and DRVVBUS interrupt */
#define USB_INTR_DRVVBUS        0x100
#define USB_INTR_RX_SHIFT       16
#define USB_INTR_TX_SHIFT       0

#define USB_MENTOR_CORE_OFFSET  0x400


#define USB_CPPI41_NUM_CH       15

INT32 usb_test(void *testargs);

#endif
